﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Threading;
using System.Windows.Forms;

using KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary;
using KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.DeviceSettingNS;
using KONICAMINOLTA.OpenAPISDK.SequenceAuthLibrary.Facade.AppRequests;
using KONICAMINOLTA.OpenAPISDK.CommonLibrary.Facade;

namespace OpenAPI_App_Manager
{
    public partial class MFPActions : UserControl
    {
        private FunctionLimitationSetting PublicUserLimits;

        private AuthAppDetails AuthApp;

        private OpenAPIWrapper openAPIHandler;
        public OpenAPIWrapper OpenAPIHandler
        {
            get
            {
                return openAPIHandler;
            }
            set
            {
                openAPIHandler = value;
                if (openAPIHandler == null || openAPIHandler.MFP == null || openAPIHandler.MFP.Address == string.Empty || !openAPIHandler.MFP.OpenAPIEnabled)
                {
                    this.Enabled = false;
                }
                else
                {
                    this.Enabled = true;
                    GetCurrentState();
                }
            }
        }

        public MFPActions()
        {
            InitializeComponent();

            this.PublicUserLimits = new FunctionLimitationSetting();
            this.AuthApp = new AuthAppDetails();         
            
            
        }

        private void buttonSetAppButton_Click(object sender, EventArgs e)
        {
            SetAppButtonText(textBoxPanelName.Text);
            
        }

        private void buttonSetAuthMode_Click(object sender, EventArgs e)
        {
            AuthSettings.PublicAuthMode Mode;
            if (radioButtonPublicOn.Checked)
                Mode = AuthSettings.PublicAuthMode.On;
            else if (radioButtonPublicOnDefault.Checked)
                Mode = AuthSettings.PublicAuthMode.OnByDefault;
            else
                Mode = AuthSettings.PublicAuthMode.Off;
            try
            {
                SetAuthMode(new AuthSettings(radioButtonAuthOn.Checked, radioButtonBoxOn.Checked, Mode, PublicUserLimits, checkBoxAllowPublicUserEdit.Checked));
            }
            catch (Exception ex)
            {
                //if ConnectionResult fails
                labelError.Text = "Authentication change failed : " + ex.Message;
            }
        }

        #region Panel Button Text
        private void SetAppButtonText(string PanelButtonText)
        {
            EnableDisablePanelButtonGroupBox(false);
            Thread tSetAppButton = new Thread(new ParameterizedThreadStart(SetPanelButtonTextInThread));
            tSetAppButton.Start(PanelButtonText);
        }

        private void SetPanelButtonTextInThread(object o)
        {
            string PanelButtonText = (string)o;

            //This method sets the "Panel Button" text.  This is the button that is used to get to OpenAPI applications.
            //It differs in location and appearance on different MFPs, however in general it is a button on the main UI
            //visible on the panel.  Note that it is NOT recommended to always rename the button to your own application
            //as this will cause user confusion when multiple applications are installed.  Instead, it should be possible
            //from your application to rename the button, but not "forced" during the registration to the MFP.

            try
            {
                //And here, we simply set the name.
                ConnectionResult cr = openAPIHandler.SetExternalAppsButtonName(PanelButtonText);
                if (cr == ConnectionResult.Ack)
                    MessageBox.Show("Panel button name set to " + PanelButtonText, "Success", MessageBoxButtons.OK, MessageBoxIcon.Information);
                else
                    MessageBox.Show("Failed to set Panel Button Name", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            catch (Exception ex)
            {
                //if ConnectionResult fails
                labelError.Text = "Failed to set Panel Button Name : " + ex.Message;
            }
            EnableDisablePanelButtonGroupBox(true);
        }

        private void GetPanelButtonTextInThread()
        {
            //This method retrieves the current "Panel Button" text from the MFP.  For further details see buttonSetAppButton_Click above
            string szButtonText = "APP";
            try
            {
                string szFromMFP = null;
                ConnectionResult cr = openAPIHandler.GetExternalAppsButtonName(out szFromMFP);
                if (cr == ConnectionResult.Ack)
                    szButtonText = szFromMFP;
            }
            catch { }

            GotPanelButtonText(szButtonText);
            EnableDisablePanelButtonGroupBox(true);
        }

        private delegate void EnableDisablePanelButtonDelegate(bool Enable);
        private void EnableDisablePanelButton(bool Enable)
        {
            groupBoxPanelButtonText.Enabled = Enable;
        }
        private void EnableDisablePanelButtonGroupBox(bool Enable)
        {
            if(this.InvokeRequired)
              this.Invoke(new EnableDisablePanelButtonDelegate(EnableDisablePanelButton), Enable);
            else
              EnableDisablePanelButton(Enable);
           
        }

        private delegate void GotPanelButtonDelegate(string PanelText);
        private void GotPanelButton(string PanelText)
        {
            this.textBoxPanelName.Text = PanelText;
        }
        private void GotPanelButtonText(string PanelText)
        {           
            if(this.InvokeRequired)
               this.Invoke(new GotPanelButtonDelegate(GotPanelButton), PanelText);
            else
               GotPanelButton(PanelText);
           
        }
        #endregion

        #region Auth Mode
        private delegate void EnableDisableAuthModeDelegate(bool Enable, string GroupBoxText);
        private void EnableDisableAuthMode(bool Enable, string GroupBoxText)
        {
            groupBoxAuthMode.Enabled = Enable;
            if (Enable)
            {
                if (GroupBoxText == string.Empty)
                    groupBoxAuthMode.Text = "Authentication Mode";
                else
                    groupBoxAuthMode.Text = "Authentication Mode for \"" + GroupBoxText + "\"";
            }
        }
        private void EnableDisableAuthModeGroupBox(bool Enable)
        {           
            if(this.InvokeRequired)
                this.Invoke(new EnableDisableAuthModeDelegate(EnableDisableAuthMode), Enable, string.Empty);
            else
                EnableDisableAuthMode(Enable, string.Empty);
          
        }
        private void EnableDisableAuthModeGroupBox(bool Enable, string GroupBoxText)
        {
            if(this.InvokeRequired)
                 this.Invoke(new EnableDisableAuthModeDelegate(EnableDisableAuthMode), Enable, GroupBoxText);
            else
                EnableDisableAuthMode(Enable, GroupBoxText);
           
        }

        private void SetAuthMode(AuthSettings Settings)
        {
            EnableDisableAuthModeGroupBox(false);
            Thread t = new Thread(new ParameterizedThreadStart(SetAuthModeInThread));
            t.Start(Settings);
        }

        private void SetAuthModeInThread(object o)
        {
            AuthSettings Settings = (AuthSettings)o;
            openAPIHandler.SetAuthenticationMode(Settings, AuthApp);
            EnableDisableAuthModeGroupBox(true, AuthApp.AppName);
        }

        private void GetAuthMode()
        {
            AuthSettings authSet = null;
            openAPIHandler.GetAuthenticationMode(out authSet);

            if (authSet != null)
                GotAuthSettings(authSet);
        }

        private delegate void GotAuthenticationSettingsDelegate(AuthSettings authSet);
        private void GotAuthenticationSettings(AuthSettings authSet)
        {
            radioButtonAuthOff.Checked = true;
            if (authSet.Enable)
            {
                radioButtonAuthOn.Checked = true;
                if (authSet.BoxAdmin)
                    radioButtonBoxOn.Checked = true;
                else
                    radioButtonBoxOff.Checked = true;
                if (authSet.PublicMode == AuthSettings.PublicAuthMode.On)
                    radioButtonPublicOn.Checked = true;
                else if (authSet.PublicMode == AuthSettings.PublicAuthMode.OnByDefault)
                    radioButtonPublicOnDefault.Checked = true;
                else
                    radioButtonPublicOff.Checked = true;
                checkBoxAllowPublicUserEdit.Checked = authSet.AdminMayEdit;
            }
        }
        private void GotAuthSettings(AuthSettings authSet)
        {
            if(this.InvokeRequired)
                this.Invoke(new GotAuthenticationSettingsDelegate(GotAuthenticationSettings), authSet);
            else
               GotAuthenticationSettings(authSet);
          
        }
        #endregion

        private void GetAuthApp()
        {
            this.AuthApp.Exists = false;
            try
            {
                KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationInfoNS.ApplicationInfoCollection resAppList = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationInfoNS.ApplicationInfoCollection();
                ConnectionResult cr = openAPIHandler.GetApplicationList(out resAppList);
                if (cr == ConnectionResult.Ack)
                {
                    foreach (KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationInfoNS.ApplicationInfo app in resAppList)
                    {
                        if (app.FunctionVersion.ApplicationType == "5" //Auth
                            || app.FunctionVersion.ApplicationType == "7") //Browser Auth
                        {
                            this.AuthApp.Exists = true;
                            this.AuthApp.BrowserAuth = (app.FunctionVersion.ApplicationType == "7");
                            this.AuthApp.AppName = app.Name;
                            this.AuthApp.AppNumber = app.No;
                            this.AuthApp.FunctionVersionMajor = int.Parse(app.FunctionVersion.Major);
                            this.AuthApp.FunctionVersionMinor = int.Parse(app.FunctionVersion.Minor);
                            break;
                        }
                    }
                }
            }
            catch
            {
            }

            if (this.AuthApp.Exists)
                EnableDisableAuthModeGroupBox(true, this.AuthApp.AppName);
            else
                EnableDisableAuthModeGroupBox(false);
        }

        private void radioButtonPublicOff_CheckedChanged(object sender, EventArgs e)
        {
            buttonPublicFunctionLimitations.Enabled = !radioButtonPublicOff.Checked;
        }

        private void buttonRefresh_Click(object sender, EventArgs e)
        {
            GetCurrentState();
        }

        private void GetCurrentState()
        {
            Thread t = new Thread(new ThreadStart(ReadMFPInThread));
            t.Start();
        }

        public void ReadMFPInThread()
        {
            BeBusy(true);
            EnableDisableAuthModeGroupBox(false);
            EnableDisablePanelButtonGroupBox(false);
            GetAuthApp();
            GetPanelButtonTextInThread();
            if (AuthApp.Exists)
                GetAuthMode();
            BeBusy(false);
        }

        private void buttonPublicFunctionLimitations_Click(object sender, EventArgs e)
        {
            frmPublicUserLimitations winLimits = new frmPublicUserLimitations(PublicUserLimits);
            if (winLimits.ShowDialog() == DialogResult.OK)
                PublicUserLimits = winLimits.Limits;
        }
        
        private delegate void BusyDelegate(bool AmBusy);
        private void Busy(bool AmBusy)
        {
            pictureBoxBusy.Visible = AmBusy;
            buttonRefresh.Visible = !AmBusy;
        }
        private void BeBusy(bool AmBusy)
        {         
            if(this.InvokeRequired)
               this.Invoke(new BusyDelegate(Busy), AmBusy);
            else
               Busy(AmBusy);
        }
    }
}
